@echo off

setlocal

set prereq=KB3033929
set find=%SystemRoot%\system32\find.exe
set wmic=%SystemRoot%\system32\wbem\wmic.exe
set wusa=%SystemRoot%\system32\wusa.exe
set wusaSN=%SystemRoot%\SysNative\wusa.exe

set win=
ver | "%find%" "10.0." >NUL && set win=windows10.0
ver | "%find%" "6.3." >NUL && set win=windows8.1
ver | "%find%" "6.2." >NUL && set win=windows8.0
ver | "%find%" "6.1." >NUL && set win=windows6.1
ver | "%find%" "6.0." >NUL && set win=windows6.0
if "%win%"=="" (
    echo.
    echo #   Error determining the Windows version!
    goto :EOF
)

set arch=x64
if %PROCESSOR_ARCHITECTURE% == x86 (
    rem our process context is 32 bit, look further...
    if not defined PROCESSOR_ARCHITEW6432 (
        rem we run on a native 32 bit Windows
        set arch=x86
        rem we keep the system32 path to wusa as it is also true on 32 bit Windows
    ) else (
        rem we run as 32bit process on 64 bit windows
        rem \sysNative only exists on 64bit windows and is only visible in 32bit processes. It is a virtual folder to the true 64bit \system32 folder.
        set wusa=%wusaSN%
    )
)
rem output system values
for %%i IN (win arch wusa) DO (
    call echo    %%i = %%%%i%%
)
echo.

rem skip Windows Update configuration for all OS except Windows 7
if "%win%" NEQ "windows6.1" (
	echo #   Windows Update configuration skipped.
	echo.
	goto :eof
)

:InstallUpdates
rem install updates
pushd "%~dp0"
echo.
echo.
echo #   The following updates will be installed: %prereq%
echo.

set "RebootRequired="
for %%A IN (%prereq%) DO (
    echo.
    echo %%A
    for /F "tokens=*" %%i IN ('dir /b /s "%win%-%%A-*%arch%*.msu"') DO (
        call :INSTALL_MSU "%%~i"
    )
)
popd
goto :eof

rem --- Procedures ---
:INSTALL_MSU
echo %~1
start /wait "" "%wusa%" "%~1" /quiet /norestart
if %errorlevel% NEQ 0 (
	if "%errorlevel%"=="3010" echo Update installed. A reboot is needed. & set RebootRequired=1 & goto :eof
	if "%errorlevel%"=="2359302" echo Update already installed & goto :eof
	if "%errorlevel%"=="-2145124329" echo Update not applicable - Wrong Architecture x86/x64? & goto :eof
	echo Unknown error occured. echo Error code=%errorlevel% & goto :eof
)
echo Update installed.

exit /b 0
